#include <stdio.h>

//NPrinterLib
typedef void(__stdcall *NCallback)(PCHAR, int, int, int);
typedef void (WINAPI *lpNSetCallback)(NCallback);
typedef INT(WINAPI *lpNEnumPrinters)(PWCHAR, PINT);
typedef INT(WINAPI *lpNRenamePrinter)(PWCHAR, PWCHAR);
typedef INT(WINAPI *lpNGetPrinterInf)(PWCHAR, PWCHAR, PDWORD);
typedef INT(WINAPI *lpNGetPrinterFromID)(PWCHAR, PWCHAR);
typedef INT(WINAPI *lpNDeletePrinter)(PWCHAR);
typedef INT(WINAPI *lpNOpenPrinter)(PWCHAR, BOOL, NCallback);
typedef INT(WINAPI *lpNClosePrinter)(PWCHAR);
typedef INT(WINAPI *lpNClosePrinters)();
typedef INT(WINAPI *lpNPrint)(PWCHAR, PCHAR, DWORD, PINT);
typedef INT(WINAPI *lpNDPrint)(PWCHAR, PBYTE, DWORD, PINT);
typedef INT(WINAPI *lpNImagePrint)(PWCHAR, HDC, INT, INT, BYTE, PINT);
typedef INT(WINAPI *lpNImagePrintF)(PWCHAR, PCHAR, BYTE, PINT);
typedef INT(WINAPI *lpNGetStatus)(PWCHAR, LPDWORD);
typedef INT(WINAPI *lpNGetInformation)(PWCHAR, BYTE, PVOID, PDWORD);
typedef INT(WINAPI *lpNResetPrinter)(PWCHAR);
typedef INT(WINAPI *lpNStartDoc)(PWCHAR, PINT);
typedef INT(WINAPI *lpNEndDoc)(PWCHAR);
typedef INT(WINAPI *lpNCancelDoc)(PWCHAR);
typedef INT(WINAPI *lpNEnumDoc)(PWCHAR, PWCHAR);
typedef INT(WINAPI *lpNDeleteDoc)(PWCHAR, INT);
typedef INT(WINAPI *lpNBarcode)(PWCHAR, PWCHAR, HDC, DWORD, DWORD, DWORD, DWORD, PBYTE, DWORD);
typedef INT(WINAPI *lpNBarcodeSettings)(UINT, UINT, UINT, CHAR, CHAR, CHAR, CHAR, UINT, UINT, UINT);
typedef INT(WINAPI *lpNBarcode2)(HDC, DWORD, DWORD, PDWORD, PDWORD, PBYTE, INT);
typedef INT(WINAPI *lpNFirmwareDL)(PWCHAR, PWCHAR, BYTE, PWORD, PINT);
typedef INT(WINAPI *lpNInitializeNetwork)(INT);
typedef INT(WINAPI *lpNScanPrinters)(long);
typedef INT(WINAPI *lpNTCPPortLock)(PWCHAR, BYTE);
typedef INT(WINAPI *lpNBufferClear)(PWCHAR);
typedef INT(WINAPI *lpNBlockSendSetting)(PWCHAR, BYTE);

typedef INT(WINAPI *lpNEnumPrintersA)(PCHAR, PINT);
typedef INT(WINAPI *lpNRenamePrinterA)(PCHAR, PCHAR);
typedef INT(WINAPI *lpNGetPrinterFromIDA)(PCHAR, PCHAR);
typedef INT(WINAPI *lpNDeletePrinterA)(PCHAR);
typedef INT(WINAPI *lpNGetPrinterInfA)(PCHAR, PCHAR, PDWORD);
typedef INT(WINAPI *lpNOpenPrinterA)(PCHAR, BOOL, NCallback);
typedef INT(WINAPI *lpNClosePrinterA)(PCHAR);
typedef INT(WINAPI *lpNPrintA)(PCHAR, PCHAR, DWORD, PINT);
typedef INT(WINAPI *lpNDPrintA)(PCHAR, PBYTE, DWORD, PINT);
typedef INT(WINAPI *lpNImagePrintA)(PCHAR, HDC, INT, INT, BYTE, PINT);
typedef INT(WINAPI *lpNImagePrintFA)(PCHAR, PCHAR, BYTE, PINT);
typedef INT(WINAPI *lpNGetStatusA)(PCHAR, LPDWORD);
typedef INT(WINAPI *lpNGetInformationA)(PCHAR, BYTE, PVOID, PDWORD);
typedef INT(WINAPI *lpNResetPrinterA)(PCHAR);
typedef INT(WINAPI *lpNStartDocA)(PCHAR, PINT);
typedef INT(WINAPI *lpNEndDocA)(PCHAR);
typedef INT(WINAPI *lpNCancelDocA)(PCHAR);
typedef INT(WINAPI *lpNEnumDocA)(PCHAR, PCHAR);
typedef INT(WINAPI *lpNDeleteDocA)(PCHAR, INT);
typedef INT(WINAPI *lpNBarcodeA)(PCHAR, PCHAR, HDC, DWORD, DWORD, DWORD, DWORD, PBYTE, DWORD);
typedef INT(WINAPI *lpNFirmwareDLA)(PCHAR, PCHAR, BYTE, PWORD, PINT);
typedef INT(WINAPI *lpNTCPPortLockA)(PCHAR, BYTE);
typedef INT(WINAPI *lpNBufferClearA)(PCHAR);
typedef INT(WINAPI *lpNBlockSendSettingA)(PCHAR, BYTE);

//NiiPrinterLib 
typedef int (WINAPI *lpNiiPrint)(PCHAR,PCHAR,DWORD,PDWORD);
typedef int (WINAPI *lpNiiImagePrintEx)(PCHAR,HDC, int,int,BYTE,PDWORD);
typedef int (WINAPI *lpNiiBitImagePrint)(PCHAR,HDC, int,int,PDWORD);
typedef int (WINAPI *lpNiiGetStatus)(PCHAR,LPDWORD);
typedef int (WINAPI *lpNiiStartDoc)(PCHAR,PDWORD);
typedef int (WINAPI *lpNiiEndDoc)(PCHAR);
typedef int (WINAPI *lpNiiCancelDoc)(PCHAR);
typedef int (WINAPI *lpNiiGetInformation)(PCHAR,BYTE,PVOID,PDWORD);

typedef int (WINAPI *lpNiiDPrint)(PCHAR,PBYTE,DWORD,PDWORD);
typedef int (WINAPI *lpNiiBarcode)(PCHAR,PCHAR,HDC,int,int,int,int,PBYTE,DWORD);

typedef int (WINAPI *lpNiiImagePrintF)(PCHAR,PCHAR,BYTE,PDWORD);
typedef int (WINAPI *lpNiiBitImagePrintF)(PCHAR,PCHAR,PDWORD);
typedef int (WINAPI *lpNiiResetPrinter)(PCHAR);






class CPrinterAPI 
{
protected:
	// Handle to a DLL
    HINSTANCE hLibHandle;

private:
	//NPrinterLib
	lpNSetCallback m_NSetCallback;
	lpNEnumPrinters m_NEnumPrinters;
	lpNRenamePrinter m_NRenamePrinter;
	lpNGetPrinterInf m_NGetPrinterInf;
	lpNGetPrinterFromID m_NGetPrinterFromID;
	lpNDeletePrinter m_NDeletePrinter;
	lpNOpenPrinter m_NOpenPrinter;
	lpNClosePrinter m_NClosePrinter;
	lpNClosePrinters m_NClosePrinters;
	lpNPrint m_NPrint;
	lpNDPrint m_NDPrint;
	lpNImagePrint m_NImagePrint;
	lpNImagePrintF m_NImagePrintF;
	lpNGetStatus m_NGetStatus;
	lpNGetInformation m_NGetInformation;
	lpNResetPrinter m_NResetPrinter;
	lpNStartDoc m_NStartDoc;
	lpNEndDoc m_NEndDoc;
	lpNCancelDoc m_NCancelDoc;
	lpNEnumDoc m_NEnumDoc;
	lpNDeleteDoc m_NDeleteDoc;
	lpNBarcode m_NBarcode;
	lpNBarcodeSettings m_NBarcodeSettings;
	lpNBarcode2 m_NBarcode2;
	lpNFirmwareDL m_NFirmwareDL;
	lpNInitializeNetwork m_NInitializeNetwork;
	lpNScanPrinters m_NScanPrinters;
	lpNTCPPortLock m_NTCPPortLock;
	lpNBufferClear m_NBufferClear;
	lpNBlockSendSetting m_NBlockSendSetting;

	lpNEnumPrintersA m_NEnumPrintersA;
	lpNRenamePrinterA m_NRenamePrinterA;
	lpNGetPrinterFromIDA m_NGetPrinterFromIDA;
	lpNDeletePrinterA m_NDeletePrinterA;
	lpNGetPrinterInfA m_NGetPrinterInfA;
	lpNOpenPrinterA m_NOpenPrinterA;
	lpNClosePrinterA m_NClosePrinterA;
	lpNPrintA m_NPrintA;
	lpNDPrintA m_NDPrintA;
	lpNImagePrintA m_NImagePrintA;
	lpNImagePrintFA m_NImagePrintFA;
	lpNGetStatusA m_NGetStatusA;
	lpNGetInformationA m_NGetInformationA;
	lpNResetPrinterA m_NResetPrinterA;
	lpNStartDocA m_NStartDocA;
	lpNEndDocA m_NEndDocA;
	lpNCancelDocA m_NCancelDocA;
	lpNEnumDocA m_NEnumDocA;
	lpNDeleteDocA m_NDeleteDocA;
	lpNBarcodeA m_NBarcodeA;
	lpNFirmwareDLA m_NFirmwareDLA;
	lpNTCPPortLockA m_NTCPPortLockA;
	lpNBufferClearA m_NBufferClearA;
	lpNBlockSendSettingA m_NBlockSendSettingA;

	//NiiPrinterLib 
    lpNiiPrint m_NiiPrint;
    lpNiiImagePrintEx m_NiiImagePrintEx;
    lpNiiBitImagePrint m_NiiBitImagePrint;
    lpNiiGetStatus m_NiiGetStatus;
    lpNiiStartDoc m_NiiStartDoc;
    lpNiiEndDoc m_NiiEndDoc;
    lpNiiCancelDoc m_NiiCancelDoc;
    lpNiiGetInformation m_NiiGetInformation;
    lpNiiDPrint m_NiiDPrint;
    lpNiiBarcode m_NiiBarcode;
    lpNiiImagePrintF m_NiiImagePrintF;
    lpNiiBitImagePrintF m_NiiBitImagePrintF;
    lpNiiResetPrinter m_NiiResetPrinter;

public:
	// Constructor
	CPrinterAPI(void)
	{
		hLibHandle = NULL;

		m_NSetCallback			= NULL;
		m_NEnumPrinters			= NULL;
		m_NRenamePrinter		= NULL;
		m_NGetPrinterInf		= NULL;
		m_NGetPrinterFromID		= NULL;
		m_NDeletePrinter		= NULL;
		m_NOpenPrinter			= NULL;
		m_NClosePrinter			= NULL;
		m_NClosePrinters		= NULL;
		m_NPrint				= NULL;
		m_NDPrint				= NULL;
		m_NImagePrint			= NULL;
		m_NImagePrintF			= NULL;
		m_NGetStatus			= NULL;
		m_NGetInformation		= NULL;
		m_NResetPrinter			= NULL;
		m_NStartDoc				= NULL;
		m_NEndDoc				= NULL;
		m_NCancelDoc			= NULL;
		m_NEnumDoc				= NULL;
		m_NDeleteDoc			= NULL;
		m_NBarcode				= NULL;
		m_NBarcodeSettings		= NULL;
		m_NBarcode2				= NULL;
		m_NFirmwareDL			= NULL;
		m_NInitializeNetwork	= NULL;
		m_NScanPrinters			= NULL;
		m_NTCPPortLock			= NULL;
		m_NBufferClear			= NULL;
		m_NBlockSendSetting		= NULL;

		m_NEnumPrintersA		= NULL;
		m_NRenamePrinterA		= NULL;
		m_NGetPrinterFromIDA	= NULL;
		m_NDeletePrinterA		= NULL;
		m_NGetPrinterInfA		= NULL;
		m_NOpenPrinterA			= NULL;
		m_NClosePrinterA		= NULL;
		m_NPrintA				= NULL;
		m_NDPrintA				= NULL;
		m_NImagePrintA			= NULL;
		m_NImagePrintFA			= NULL;
		m_NGetStatusA			= NULL;
		m_NGetInformationA		= NULL;
		m_NResetPrinterA		= NULL;
		m_NStartDocA			= NULL;
		m_NEndDocA				= NULL;
		m_NCancelDocA			= NULL;
		m_NEnumDocA				= NULL;
		m_NDeleteDocA			= NULL;
		m_NBarcodeA				= NULL;
		m_NFirmwareDLA			= NULL;
		m_NTCPPortLockA			= NULL;
		m_NBufferClearA			= NULL;
		m_NBlockSendSettingA	= NULL;

		m_NiiPrint          = NULL;
		m_NiiImagePrintEx   = NULL;
		m_NiiBitImagePrint  = NULL;
		m_NiiGetStatus      = NULL;
		m_NiiStartDoc       = NULL;
		m_NiiEndDoc         = NULL;
		m_NiiCancelDoc      = NULL;
		m_NiiGetInformation = NULL;
		m_NiiDPrint         = NULL;
		m_NiiBarcode        = NULL;
		m_NiiImagePrintF    = NULL;
		m_NiiBitImagePrintF = NULL;
		m_NiiResetPrinter   = NULL;
	};
	//Destructor
	virtual ~CPrinterAPI()
	{
		if ( hLibHandle != NULL ) 
		{
			::FreeLibrary(hLibHandle);
		}
	};

	// Public API Functions. Must call Initialize() before anything else
	BOOL Initialize()
	{
		hLibHandle = ::LoadLibrary("NPrinterLib.DLL");
		if ( hLibHandle != NULL ) 
		{
			m_NSetCallback = (lpNSetCallback)GetProcAddress(hLibHandle, "NSetCallback");
			m_NEnumPrinters = (lpNEnumPrinters)GetProcAddress(hLibHandle, "NEnumPrinters");
			m_NRenamePrinter = (lpNRenamePrinter)GetProcAddress(hLibHandle, "NRenamePrinter");
			m_NGetPrinterInf = (lpNGetPrinterInf)GetProcAddress(hLibHandle, "NGetPrinterInf");
			m_NGetPrinterFromID = (lpNGetPrinterFromID)GetProcAddress(hLibHandle, "NGetPrinterFromID");
			m_NDeletePrinter = (lpNDeletePrinter)GetProcAddress(hLibHandle, "NDeletePrinter");
			m_NOpenPrinter = (lpNOpenPrinter)GetProcAddress(hLibHandle, "NOpenPrinter");
			m_NClosePrinter = (lpNClosePrinter)GetProcAddress(hLibHandle, "NClosePrinter");
			m_NClosePrinters = (lpNClosePrinters)GetProcAddress(hLibHandle, "NClosePrinters");
			m_NPrint = (lpNPrint)GetProcAddress(hLibHandle, "NPrint");
			m_NDPrint = (lpNDPrint)GetProcAddress(hLibHandle, "NDPrint");
			m_NImagePrint = (lpNImagePrint)GetProcAddress(hLibHandle, "NImagePrint");
			m_NImagePrintF = (lpNImagePrintF)GetProcAddress(hLibHandle, "NImagePrintF");
			m_NGetStatus = (lpNGetStatus)GetProcAddress(hLibHandle, "NGetStatus");
			m_NGetInformation = (lpNGetInformation)GetProcAddress(hLibHandle, "NGetInformation");
			m_NResetPrinter = (lpNResetPrinter)GetProcAddress(hLibHandle, "NResetPrinter");
			m_NStartDoc = (lpNStartDoc)GetProcAddress(hLibHandle, "NStartDoc");
			m_NEndDoc = (lpNEndDoc)GetProcAddress(hLibHandle, "NEndDoc");
			m_NCancelDoc = (lpNCancelDoc)GetProcAddress(hLibHandle, "NCancelDoc");
			m_NEnumDoc = (lpNEnumDoc)GetProcAddress(hLibHandle, "NEnumDoc");
			m_NDeleteDoc = (lpNDeleteDoc)GetProcAddress(hLibHandle, "NDeleteDoc");
			m_NBarcode = (lpNBarcode)GetProcAddress(hLibHandle, "NBarcode");
			m_NBarcodeSettings = (lpNBarcodeSettings)GetProcAddress(hLibHandle, "NBarcodeSettings");
			m_NBarcode2 = (lpNBarcode2)GetProcAddress(hLibHandle, "NBarcode2");
			m_NFirmwareDL = (lpNFirmwareDL)GetProcAddress(hLibHandle, "NFirmwareDL");
			m_NInitializeNetwork = (lpNInitializeNetwork)GetProcAddress(hLibHandle, "NInitializeNetwork");
			m_NScanPrinters = (lpNScanPrinters)GetProcAddress(hLibHandle, "NScanPrinters");
			m_NTCPPortLock = (lpNTCPPortLock)GetProcAddress(hLibHandle, "NTCPPortLock");
			m_NBufferClear = (lpNBufferClear)GetProcAddress(hLibHandle, "NBufferClear");
			m_NBlockSendSetting = (lpNBlockSendSetting)GetProcAddress(hLibHandle, "NBlockSendSetting");

			m_NEnumPrintersA = (lpNEnumPrintersA)GetProcAddress(hLibHandle, "NEnumPrintersA");
			m_NRenamePrinterA = (lpNRenamePrinterA)GetProcAddress(hLibHandle, "NRenamePrinterA");
			m_NGetPrinterInfA = (lpNGetPrinterInfA)GetProcAddress(hLibHandle, "NGetPrinterInfA");
			m_NDeletePrinterA = (lpNDeletePrinterA)GetProcAddress(hLibHandle, "NDeletePrinterA");
			m_NGetPrinterFromIDA = (lpNGetPrinterFromIDA)GetProcAddress(hLibHandle, "NGetPrinterFromIDA");
			m_NOpenPrinterA = (lpNOpenPrinterA)GetProcAddress(hLibHandle, "NOpenPrinterA");
			m_NClosePrinterA = (lpNClosePrinterA)GetProcAddress(hLibHandle, "NClosePrinterA");
			m_NPrintA = (lpNPrintA)GetProcAddress(hLibHandle, "NPrintA");
			m_NDPrintA = (lpNDPrintA)GetProcAddress(hLibHandle, "NDPrintA");
			m_NImagePrintA = (lpNImagePrintA)GetProcAddress(hLibHandle, "NImagePrintA");
			m_NImagePrintFA = (lpNImagePrintFA)GetProcAddress(hLibHandle, "NImagePrintFA");
			m_NGetStatusA = (lpNGetStatusA)GetProcAddress(hLibHandle, "NGetStatusA");
			m_NGetInformationA = (lpNGetInformationA)GetProcAddress(hLibHandle, "NGetInformationA");
			m_NResetPrinterA = (lpNResetPrinterA)GetProcAddress(hLibHandle, "NResetPrinterA");
			m_NStartDocA = (lpNStartDocA)GetProcAddress(hLibHandle, "NStartDocA");
			m_NEndDocA = (lpNEndDocA)GetProcAddress(hLibHandle, "NEndDocA");
			m_NCancelDocA = (lpNCancelDocA)GetProcAddress(hLibHandle, "NCancelDocA");
			m_NEnumDocA = (lpNEnumDocA)GetProcAddress(hLibHandle, "NEnumDocA");
			m_NDeleteDocA = (lpNDeleteDocA)GetProcAddress(hLibHandle, "NDeleteDocA");
			m_NBarcodeA = (lpNBarcodeA)GetProcAddress(hLibHandle, "NBarcodeA");
			m_NFirmwareDLA = (lpNFirmwareDLA)GetProcAddress(hLibHandle, "NFirmwareDLA");
			m_NTCPPortLockA = (lpNTCPPortLockA)GetProcAddress(hLibHandle, "NTCPPortLockA");
			m_NBufferClearA = (lpNBufferClearA)GetProcAddress(hLibHandle, "NBufferClearA");
			m_NBlockSendSettingA = (lpNBlockSendSettingA)GetProcAddress(hLibHandle, "NBlockSendSettingA");

			m_NiiPrint = (lpNiiPrint)GetProcAddress(hLibHandle,"NiiPrint");
			m_NiiImagePrintEx = (lpNiiImagePrintEx)GetProcAddress(hLibHandle,"NiiImagePrintEx");
			m_NiiBitImagePrint = (lpNiiBitImagePrint)GetProcAddress(hLibHandle,"NiiBitImagePrint");
			m_NiiGetStatus = (lpNiiGetStatus)GetProcAddress(hLibHandle,"NiiGetStatus");
			m_NiiStartDoc = (lpNiiStartDoc)GetProcAddress(hLibHandle,"NiiStartDoc");
			m_NiiEndDoc = (lpNiiEndDoc)GetProcAddress(hLibHandle,"NiiEndDoc");
			m_NiiCancelDoc = (lpNiiCancelDoc)GetProcAddress(hLibHandle,"NiiCancelDoc");
			m_NiiGetInformation = (lpNiiGetInformation)GetProcAddress(hLibHandle,"NiiGetInformation");
			m_NiiDPrint = (lpNiiDPrint)GetProcAddress(hLibHandle,"NiiDPrint");
			m_NiiBarcode = (lpNiiBarcode)GetProcAddress(hLibHandle,"NiiBarcode");
			m_NiiImagePrintF = (lpNiiImagePrintF)GetProcAddress(hLibHandle,"NiiImagePrintF");
			m_NiiBitImagePrintF = (lpNiiBitImagePrintF)GetProcAddress(hLibHandle,"NiiBitImagePrintF");
			m_NiiResetPrinter = (lpNiiResetPrinter)GetProcAddress(hLibHandle,"NiiResetPrinter");

			if (m_NSetCallback != NULL &&
				m_NEnumPrinters != NULL &&
				m_NRenamePrinter != NULL &&
				m_NGetPrinterInf != NULL &&
				m_NGetPrinterFromID != NULL &&
				m_NDeletePrinter != NULL &&
				m_NOpenPrinter != NULL &&
				m_NClosePrinter != NULL &&
				m_NClosePrinters != NULL &&
				m_NPrint != NULL &&
				m_NDPrint != NULL &&
				m_NImagePrint != NULL &&
				m_NImagePrintF != NULL &&
				m_NGetStatus != NULL &&
				m_NGetInformation != NULL &&
				m_NResetPrinter != NULL &&
				m_NStartDoc != NULL &&
				m_NEndDoc != NULL &&
				m_NCancelDoc != NULL &&
				m_NEnumDoc != NULL &&
				m_NDeleteDoc != NULL &&
				m_NBarcode != NULL &&
				m_NBarcodeSettings != NULL &&
				m_NBarcode2 != NULL &&
				m_NFirmwareDL != NULL &&
				m_NInitializeNetwork != NULL &&
				m_NScanPrinters != NULL &&
				m_NTCPPortLock != NULL &&
				m_NBufferClear != NULL &&
				m_NBlockSendSetting != NULL &&

				m_NEnumPrintersA != NULL &&
				m_NRenamePrinterA != NULL &&
				m_NGetPrinterFromIDA != NULL &&
				m_NDeletePrinterA != NULL &&
				m_NGetPrinterInfA != NULL &&
				m_NOpenPrinterA != NULL &&
				m_NClosePrinterA != NULL &&
				m_NPrintA != NULL &&
				m_NDPrintA != NULL &&
				m_NImagePrintA != NULL &&
				m_NImagePrintFA != NULL &&
				m_NGetStatusA != NULL &&
				m_NGetInformationA != NULL &&
				m_NResetPrinterA != NULL &&
				m_NStartDocA != NULL &&
				m_NEndDocA != NULL &&
				m_NCancelDocA != NULL &&
				m_NEnumDocA != NULL &&
				m_NDeleteDocA != NULL &&
				m_NBarcodeA != NULL &&
				m_NFirmwareDLA != NULL &&
				m_NTCPPortLockA != NULL &&
				m_NBufferClearA != NULL &&
				m_NBlockSendSettingA != NULL &&
					
				m_NiiPrint != NULL &&
				m_NiiImagePrintEx != NULL &&
				m_NiiBitImagePrint != NULL &&
				m_NiiGetStatus != NULL &&
				m_NiiStartDoc != NULL &&
				m_NiiEndDoc != NULL &&
				m_NiiCancelDoc != NULL &&
				m_NiiGetInformation != NULL &&
				m_NiiDPrint != NULL &&
				m_NiiBarcode != NULL &&
				m_NiiImagePrintF != NULL &&
				m_NiiBitImagePrintF != NULL &&
				m_NiiResetPrinter != NULL)
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		else
		{
			return FALSE;
		}
	};


	void NSetCallback(NCallback i_callback)
	{
		if (m_NSetCallback != NULL)
		{
			return m_NSetCallback(i_callback);
		}
	}
	INT NEnumPrinters(PWCHAR o_printers, PINT o_size)
	{
		if (m_NEnumPrinters != NULL)
		{
			return m_NEnumPrinters(o_printers, o_size);
		}
		return -9999;
	}
	INT NRenamePrinter(PWCHAR i_beforeprt, PWCHAR i_afterprt)
	{
		if (m_NRenamePrinter != NULL)
		{
			return m_NRenamePrinter(i_beforeprt, i_afterprt);
		}
		return -9999;
	}
	INT NGetPrinterInf(PWCHAR i_prt, PWCHAR o_ports, PDWORD o_size)
	{
		if (m_NGetPrinterInf != NULL)
		{
			return m_NGetPrinterInf(i_prt, o_ports, o_size);
		}
		return -9999;
	}
	INT NGetPrinterFromID(PWCHAR i_ID, PWCHAR o_printer)
	{
		if (m_NGetPrinterFromID != NULL)
		{
			return m_NGetPrinterFromID(i_ID, o_printer);
		}
		return -9999;
	}
	INT NDeletePrinter(PWCHAR i_prt)
	{
		if (m_NDeletePrinter != NULL)
		{
			return m_NDeletePrinter(i_prt);
		}
		return -9999;
	}
	INT NOpenPrinter(PWCHAR i_prt, BOOL i_statusFlg, NCallback i_callback)
	{
		if (m_NOpenPrinter != NULL)
		{
			return m_NOpenPrinter(i_prt, i_statusFlg, i_callback);
		}
		return -9999;
	}
	INT NClosePrinter(PWCHAR i_prt)
	{
		if (m_NClosePrinter != NULL)
		{
			return m_NClosePrinter(i_prt);
		}
		return -9999;
	}
	INT NClosePrinters()
	{
		if (m_NClosePrinters != NULL)
		{
			return m_NClosePrinters();
		}
		return -9999;
	}
	INT NPrint(PWCHAR i_prt, PCHAR i_dat, DWORD i_size, PINT o_jobid)
	{
		if (m_NPrint != NULL)
		{
			return m_NPrint(i_prt,i_dat,i_size,o_jobid);
		}
		return -9999;
	}
	INT NDPrint(PWCHAR i_prt, PBYTE i_dat, DWORD i_size, PINT o_jobid)
	{
		if (m_NDPrint != NULL)
		{
			return m_NDPrint(i_prt, i_dat, i_size, o_jobid);
		}
		return -9999;
	}
	INT NImagePrint(PWCHAR i_prt, HDC i_bmp, INT i_width, INT i_height, BYTE i_putType, PINT o_jobid)
	{
		if (m_NImagePrint != NULL)
		{
			return m_NImagePrint(i_prt, i_bmp, i_width, i_height, i_putType, o_jobid);
		}
		return -9999;
	}
	INT NImagePrintF(PWCHAR i_prt, PCHAR i_bmp, BYTE i_putType, PINT o_jobid)
	{
		if (m_NImagePrintF != NULL)
		{
			return m_NImagePrintF(i_prt, i_bmp, i_putType, o_jobid);
		}
		return -9999;
	}
	INT NGetStatus(PWCHAR i_prt, LPDWORD o_status)
	{
		if (m_NGetStatus != NULL)
		{
			return m_NGetStatus(i_prt, o_status);
		}
		return -9999;
	}
	INT NGetInformation(PWCHAR i_prt, BYTE i_id, PVOID o_dat, PDWORD o_time)
	{
		if (m_NGetInformation != NULL)
		{
			return m_NGetInformation(i_prt, i_id, o_dat, o_time);
		}
		return -9999;
	}
	INT NResetPrinter(PWCHAR i_prt)
	{
		if (m_NResetPrinter != NULL)
		{
			return m_NResetPrinter(i_prt);
		}
		return -9999;
	}
	INT NStartDoc(PWCHAR i_prt, PINT o_jobid)
	{
		if (m_NStartDoc != NULL)
		{
			return m_NStartDoc(i_prt, o_jobid);
		}
		return -9999;
	}
	INT NEndDoc(PWCHAR i_prt)
	{
		if (m_NEndDoc != NULL)
		{
			return m_NEndDoc(i_prt);
		}
		return -9999;
	}
	INT NCancelDoc(PWCHAR i_prt)
	{
		if (m_NCancelDoc != NULL)
		{
			return m_NCancelDoc(i_prt);
		}
		return -9999;
	}
	INT NEnumDoc(PWCHAR i_prt, PWCHAR o_list)
	{
		if (m_NEnumDoc != NULL)
		{
			return m_NEnumDoc(i_prt, o_list);
		}
		return -9999;
	}
	INT NDeleteDoc(PWCHAR i_prt, INT i_jobID)
	{
		if (m_NDeleteDoc != NULL)
		{
			return m_NDeleteDoc(i_prt, i_jobID);
		}
		return -9999;
	}
	INT NBarcode(PWCHAR i_prt, PWCHAR i_fontName, HDC o_bmp, DWORD i_x, DWORD i_y, DWORD i_width, DWORD i_height, PBYTE i_dat, DWORD i_size)
	{
		if (m_NBarcode != NULL)
		{
			return m_NBarcode(i_prt, i_fontName, o_bmp, i_x, i_y, i_width, i_height, i_dat, i_size);
		}
		return -9999;
	}
	INT NBarcodeSettings(UINT i_id, UINT i_width, UINT i_height, CHAR i_option1, CHAR i_option2, CHAR i_option3, CHAR i_option4, UINT i_hri, UINT i_spin, UINT i_code)
	{
		if (m_NBarcodeSettings != NULL)
		{
			return m_NBarcodeSettings(i_id, i_width, i_height, i_option1, i_option2, i_option3, i_option4, i_hri, i_spin, i_code);
		}
		return -9999;
	}
	INT NBarcode2(HDC o_bmp, DWORD i_x, DWORD i_y, PDWORD io_width, PDWORD io_height, PBYTE i_dat, INT i_size)
	{
		if (m_NBarcode2 != NULL)
		{
			return m_NBarcode2(o_bmp, i_x, i_y, io_width, io_height, i_dat, i_size);
		}
		return -9999;
	}
	INT NFirmwareDL(PWCHAR i_prt, PWCHAR i_file, BYTE i_errflg, PWORD io_chksum, PINT o_jobid)
	{
		if (m_NFirmwareDL != NULL)
		{
			return m_NFirmwareDL(i_prt, i_file, i_errflg, io_chksum, o_jobid);
		}
		return -9999;
	}
	INT NInitializeNetwork(INT i_flg)
	{
		if (m_NInitializeNetwork != NULL)
		{
			return m_NInitializeNetwork(i_flg);
		}
		return -9999;
	}
	INT NScanPrinters(long i_waitmsec)
	{
		if (m_NScanPrinters != NULL)
		{
			return m_NScanPrinters(i_waitmsec);
		}
		return -9999;
	}
	INT NTCPPortLock(PWCHAR i_prt, BYTE i_type)
	{
		if (m_NTCPPortLock != NULL)
		{
			return m_NTCPPortLock(i_prt, i_type);
		}
		return -9999;
	}
	INT NBufferClear(PWCHAR i_prt)
	{
		if (m_NBufferClear != NULL)
		{
			return m_NBufferClear(i_prt);
		}
		return -9999;
	}
	INT NBlockSendSetting(PWCHAR i_prt, BYTE i_type)
	{
		if (m_NBlockSendSetting != NULL)
		{
			return m_NBlockSendSetting(i_prt, i_type);
		}
		return -9999;
	}


	INT NEnumPrintersA(PCHAR o_printers, PINT o_size)
	{
		if (m_NEnumPrintersA != NULL)
		{
			return m_NEnumPrintersA(o_printers, o_size);
		}
		return -9999;
	}
	INT NRenamePrinterA(PCHAR i_beforeprt, PCHAR i_afterprt)
	{
		if (m_NRenamePrinterA != NULL)
		{
			return m_NRenamePrinterA(i_beforeprt, i_afterprt);
		}
		return -9999;
	}
	INT NGetPrinterFromIDA(PCHAR i_ID, PCHAR o_printer)
	{
		if (m_NGetPrinterFromIDA != NULL)
		{
			return m_NGetPrinterFromIDA(i_ID, o_printer);
		}
		return -9999;
	}
	INT NDeletePrinterA(PCHAR i_prt)
	{
		if (m_NDeletePrinterA != NULL)
		{
			return m_NDeletePrinterA(i_prt);
		}
		return -9999;
	}
	INT NGetPrinterInfA(PCHAR i_prt, PCHAR o_ports, PDWORD o_size)
	{
		if (m_NGetPrinterInfA != NULL)
		{
			return m_NGetPrinterInfA(i_prt, o_ports, o_size);
		}
		return -9999;
	}
	INT NOpenPrinterA(PCHAR i_prt, BOOL i_statusFlg, NCallback i_callback)
	{
		if (m_NOpenPrinterA != NULL)
		{
			return m_NOpenPrinterA(i_prt, i_statusFlg, i_callback);
		}
		return -9999;
	}
	INT NClosePrinterA(PCHAR i_prt)
	{
		if (m_NClosePrinterA != NULL)
		{
			return m_NClosePrinterA(i_prt);
		}
		return -9999;
	}
	INT NPrintA(PCHAR i_prt, PCHAR i_dat, DWORD i_size, PINT o_jobid)
	{
		if (m_NPrintA != NULL)
		{
			return m_NPrintA(i_prt, i_dat, i_size, o_jobid);
		}
		return -9999;
	}
	INT NDPrintA(PCHAR i_prt, PBYTE i_dat, DWORD i_size, PINT o_jobid)
	{
		if (m_NDPrintA != NULL)
		{
			return m_NDPrintA(i_prt, i_dat, i_size, o_jobid);
		}
		return -9999;
	}
	INT NImagePrintA(PCHAR i_prt, HDC i_bmp, INT i_width, INT i_height, BYTE i_putType, PINT o_jobid)
	{
		if (m_NImagePrintA != NULL)
		{
			return m_NImagePrintA(i_prt, i_bmp, i_width, i_height, i_putType, o_jobid);
		}
		return -9999;
	}
	INT NImagePrintFA(PCHAR i_prt, PCHAR i_bmp, BYTE i_putType, PINT o_jobid)
	{
		if (m_NImagePrintFA != NULL)
		{
			return m_NImagePrintFA(i_prt, i_bmp, i_putType, o_jobid);
		}
		return -9999;
	}
	INT NGetStatusA(PCHAR i_prt, LPDWORD o_status)
	{
		if (m_NGetStatusA != NULL)
		{
			return m_NGetStatusA(i_prt, o_status);
		}
		return -9999;
	}
	INT NGetInformationA(PCHAR i_prt, BYTE i_id, PVOID o_dat, PDWORD o_time)
	{
		if (m_NGetInformationA != NULL)
		{
			return m_NGetInformationA(i_prt, i_id, o_dat, o_time);
		}
		return -9999;
	}
	INT NResetPrinterA(PCHAR i_prt)
	{
		if (m_NResetPrinterA != NULL)
		{
			return m_NResetPrinterA(i_prt);
		}
		return -9999;
	}
	INT NStartDocA(PCHAR i_prt, PINT o_jobid)
	{
		if (m_NStartDocA != NULL)
		{
			return m_NStartDocA(i_prt, o_jobid);
		}
		return -9999;
	}
	INT NEndDocA(PCHAR i_prt)
	{
		if (m_NEndDocA != NULL)
		{
			return m_NEndDocA(i_prt);
		}
		return -9999;
	}
	INT NCancelDocA(PCHAR i_prt)
	{
		if (m_NCancelDocA != NULL)
		{
			return m_NCancelDocA(i_prt);
		}
		return -9999;
	}
	INT NEnumDocA(PCHAR i_prt, PCHAR o_list)
	{
		if (m_NEnumDocA != NULL)
		{
			return m_NEnumDocA(i_prt, o_list);
		}
		return -9999;
	}
	INT NDeleteDocA(PCHAR i_prt, INT i_jobID)
	{
		if (m_NDeleteDocA != NULL)
		{
			return m_NDeleteDocA(i_prt, i_jobID);
		}
		return -9999;
	}
	INT NBarcodeA(PCHAR i_prt, PCHAR i_fontName, HDC o_bmp, DWORD i_x, DWORD i_y, DWORD i_width, DWORD i_height, PBYTE i_dat, DWORD i_size)
	{
		if (m_NBarcodeA != NULL)
		{
			return m_NBarcodeA(i_prt, i_fontName, o_bmp, i_x, i_y, i_width, i_height, i_dat, i_size);
		}
		return -9999;
	}
	INT NFirmwareDLA(PCHAR i_prt, PCHAR i_file, BYTE i_errflg, PWORD io_chksum, PINT o_jobid)
	{
		if (m_NFirmwareDLA != NULL)
		{
			return m_NFirmwareDLA(i_prt, i_file, i_errflg, io_chksum, o_jobid);
		}
		return -9999;
	}
	INT NTCPPortLockA(PCHAR i_prt, BYTE i_type)
	{
		if (m_NTCPPortLockA != NULL)
		{
			return m_NTCPPortLockA(i_prt, i_type);
		}
		return -9999;
	}
	INT NBufferClearA(PCHAR i_prt)
	{
		if (m_NBufferClearA != NULL)
		{
			return m_NBufferClearA(i_prt);
		}
		return -9999;
	}
	INT NBlockSendSettingA(PCHAR i_prt, BYTE i_type) 
	{
		if (m_NBlockSendSettingA != NULL)
		{
			return m_NBlockSendSettingA(i_prt, i_type);
		}
		return -9999;
	}


	int NiiPrint(PCHAR i_prt, PCHAR i_dat, DWORD i_size, PDWORD o_jobid)
	{
		if (m_NiiPrint!=NULL ) 
			return m_NiiPrint(i_prt, i_dat, i_size, o_jobid);
		return -9999;
	};
	int NiiImagePrintEx(PCHAR i_prt, HDC i_bmp, int i_x, int i_y, BYTE i_file, PDWORD o_jobid)
	{
		if (m_NiiImagePrintEx!=NULL ) 
			return m_NiiImagePrintEx(i_prt, i_bmp, i_x, i_y, i_file, o_jobid);
		return -9999;
	};
	int NiiBitImagePrint(PCHAR i_prt, HDC i_bmp, int i_x, int i_y, PDWORD o_jobid)
	{
		if (m_NiiBitImagePrint!=NULL ) 
			return m_NiiBitImagePrint( i_prt,  i_bmp,  i_x,  i_y,  o_jobid);
		return -9999;
	};
	int NiiGetStatus(PCHAR i_prt, LPDWORD o_status)
	{
		if (m_NiiGetStatus!=NULL ) 
			return m_NiiGetStatus( i_prt,  o_status);
		return -9999;
	};
	int NiiStartDoc(PCHAR i_prt, PDWORD o_jobid)
	{
		if (m_NiiStartDoc!=NULL ) 
			return m_NiiStartDoc( i_prt,  o_jobid);
		return -9999;
	};
	int NiiEndDoc(PCHAR i_prt)
	{
		if (m_NiiEndDoc!=NULL ) 
			return m_NiiEndDoc( i_prt);
		return -9999;
	};
	int NiiCancelDoc(PCHAR i_prt)
	{
		if (m_NiiCancelDoc!=NULL ) 
			return m_NiiCancelDoc( i_prt);
		return -9999;
	};
	int NiiGetInformation(PCHAR i_prt, BYTE i_id, PVOID o_dat, PDWORD o_time)
	{
		if (m_NiiGetInformation!=NULL ) 
			return m_NiiGetInformation( i_prt,  i_id,  o_dat,  o_time);
		return -9999;
	};
	int NiiDPrint(PCHAR i_prt, PBYTE i_dat, DWORD i_size, PDWORD o_jobid)
	{
		if (m_NiiDPrint!=NULL ) 
			return m_NiiDPrint( i_prt,  i_dat,  i_size,  o_jobid);
		return -9999;
	};
	int NiiBarcode(PCHAR i_prt,PCHAR i_fname, HDC i_bmp, int i_x, int i_y, int i_width, int i_height,PBYTE i_dat,DWORD i_size)
	{
		if (m_NiiBarcode!=NULL ) 
			return m_NiiBarcode( i_prt, i_fname,  i_bmp,  i_x,  i_y, i_width, i_height, i_dat, i_size);
		return -9999;
	};
	int NiiImagePrintF(PCHAR i_prt, PCHAR i_bmp, BYTE i_file, PDWORD o_jobid)
	{
		if (m_NiiImagePrintEx!=NULL ) 
			return m_NiiImagePrintF(i_prt, i_bmp, i_file, o_jobid);
		return -9999;
	};
	int NiiBitImagePrintF(PCHAR i_prt, PCHAR i_bmp, PDWORD o_jobid)
	{
		if (m_NiiBitImagePrint!=NULL ) 
			return m_NiiBitImagePrintF( i_prt,  i_bmp,  o_jobid);
		return -9999;
	};
	int NiiResetPrinter(PCHAR i_prt)
	{
		if (m_NiiResetPrinter!=NULL ) 
			return m_NiiResetPrinter( i_prt);
		return -9999;
	};

};