// Sample8Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample8.h"
#include "Sample8Dlg.h"
#include "ImportAPI.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSample8Dlg dialog


//////////////////////////////////////////////////////////////////////////////////////////////
//Mounting PrinterAPI  
//////////////////////////////////////////////////////////////////////////////////////////////
CPrinterAPI	PrinterAPI;

CSample8Dlg::CSample8Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSample8Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSample8Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CSample8Dlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDPractice, &CSample8Dlg::OnBnClickedPrintSample)
END_MESSAGE_MAP()


// CSample8Dlg message handlers

BOOL CSample8Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	//////////////////////////////////////////////////////////////////////////////////////////////
	//Load PrinterAPI
	//////////////////////////////////////////////////////////////////////////////////////////////
	if ( PrinterAPI.Initialize() == FALSE ) 
	{
		AfxMessageBox(_T("Error :Load PrinterAPI"));
		return FALSE;
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSample8Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}


void CSample8Dlg::OnBnClickedPrintSample()
{
int ret;
DWORD st;	//v^Xe[^X
BYTE prtinf[64];	//g
DWORD tm;	//g^CX^v
DWORD htm;	//g^CX^v
INT JOBID;

DWORD wk;

BYTE szCommand[256];   //o̓f[^i[GA
int	 nmuCmdCnt = 0;		//R}hoCg
WCHAR DriverName[] = L"NPI Integration Driver";	//hCo


RETRY:
	//ݏ󋵊mF
	ret = PrinterAPI.NGetStatus(DriverName,&st);
	//ڑ󋵃`FbN
	if (ret == -5)
	{
		AfxMessageBox(_T("Printer OFFLINE"));
		return;
	}
	else if (ret == -31)
	{
		AfxMessageBox(_T("LACK RESOURCE Error"));
		return;
	}
	else if (ret == -91 || ret == -92)
	{
		AfxMessageBox(_T("NGetStatus ARGUMENT Error"));
		return;
	}
	else if(ret != 0)
	{
		AfxMessageBox(_T("NGetStatus Error"));
		return;
	}

	//v^ԃ`FbN
	if ((st & 0x02) > 0)
	{
		AfxMessageBox(_T("Head Open"));
		return;
	}
	if ((st & 0x04) > 0)
	{
		AfxMessageBox(_T("Paper End"));
		return;
	}
	if ((st & 0xF8) > 0)
	{
		AfxMessageBox(_T("Other Error"));
		return;
	}

	ret = PrinterAPI.NGetInformation(DriverName,19,prtinf,&tm);			//݈󎚊ʒmԎ擾
	htm = tm;
	ret = PrinterAPI.NStartDoc(DriverName,&JOBID);						//hLgJn
	if(ret != 0)
	{	
		AfxMessageBox(_T("Error:StartDoc"));
		return;
	}
	//󎚊Jn錾(GS G 11)R}h
	szCommand[nmuCmdCnt++] = 0x1D;
	szCommand[nmuCmdCnt++] = 0x47;
	szCommand[nmuCmdCnt++] = 0x11;
	memcpy((PDWORD)&szCommand[nmuCmdCnt], &JOBID, 4);
	nmuCmdCnt += 4;
	PrinterAPI.NDPrint(DriverName,szCommand, nmuCmdCnt,NULL);					//󎚊Jn錾(GS G 11)R}hs
	PrinterAPI.NPrint(DriverName,"1D\"P\"001B\"J\"08",strlen("1D\"P\"001B\"J\"08"),NULL);	//NVC[WR}h,R}hs
	//󎚃f[^MiV[gj
	PrinterAPI.NPrint(DriverName,"\"Part Name          Num       Price     SubTotal\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"-----------------------------------------------\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Paper                2          60          120\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Pencil               1         100          100\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Eraser               1          90           90\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Note                 1          80           80\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Book                 1         500          500\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Calendar             1        1200         1200\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Rule                 1         120          120\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Calculator           1        3980         3980\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Bookends             1          90           90\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Stapler              1         110          110\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Pen(black)           1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Pen(red)             1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Pen(blue)            1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Pen(yellow)          1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Pen(green)           1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Pen(pink)            1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Pen(Purple)          1          70           70\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"Scissors             1         200          200\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"-----------------------------------------------\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"\"                                    Total 7,080\"0a", 51,NULL);
	PrinterAPI.NPrint(DriverName,"1B\"J\"68",strlen("1B\"J\"68"),NULL);	//R}hs(Jbgʒu܂ňړj
	PrinterAPI.NPrint(DriverName,"1B\"m\"",strlen("1B\"m\""),NULL);		//JbgR}hs
	
	//󎚃f[^Miij
	PrinterAPI.NImagePrintF(DriverName,"c:\\GIFT_Certificate.bmp",1,NULL);
	PrinterAPI.NPrint(DriverName,"1B\"J\"97",strlen("1B\"J\"97"),NULL);	//R}hs(Jbgʒu܂ňړj
	PrinterAPI.NPrint(DriverName,"1B\"m\"",strlen("1B\"m\""),NULL);		//JbgR}hs

	PrinterAPI.NPrint(DriverName,"1D4710",6,NULL);						//󎚊錾(GS G 10)R}hs
	PrinterAPI.NEndDoc(DriverName);

RETRYWAIT:
	//M҂
	while(htm == tm)
	{
		ret = PrinterAPI.NGetInformation(DriverName,19,prtinf,&tm);
		//ڑ󋵃`FbN
		if(ret != 0)
		{
			AfxMessageBox(_T("Get Error"));
			return;
		}
	}

	memcpy(&wk,prtinf,4);
	if(JOBID == wk)
	{
		memcpy(&wk,&prtinf[4],4);
		if(wk != 0)
		{
			AfxMessageBox("Failed to Print!!",MB_ICONINFORMATION);
			goto RETRY;
		}
	}
	else
	{
		htm = tm;
		goto RETRYWAIT;
	}
		 
	AfxMessageBox("FINISH!!",MB_ICONINFORMATION);
}